// @(#)tp1.C	1.3
#include <stream.h> 
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

  // Use SLEEP to hide errno which is generated by exiting from sleep on the Suns
#define SLEEP(_x) { int storeerrno; storeerrno = errno; sleep(_x); errno = storeerrno; }

#define DOIT(_b,_l) \
	{ \
	pout.setbuf(_b,_l); \
	if (!pout) cerr << "setbuf() failed, line " << __LINE__ << "\n"; \
	pout.write(data,len); \
	pout << flush; \
	if (!pout) cerr << "write() or flush failed, line " << __LINE__ << "\n"; \
	}

void main()
	{
	static char data[] = "123456789012345678901234567890123456789\n";
	char buf[80];
	int len;
	opstream 	pout("cat");

	cout << "This test will try to write a single block of data\n";
	cout << "to the input of a \"cat\" process several times\n";
	cout << "using a different buffer size each time.  You should\n";
	cout << "see the following output on your screen:\n";
	cout << "---------------------------------------\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "About to close() with childisdead() = 0 and errno = 0\n";
	cout << "Closed.  childisdead() = 1\n";
	cout << "---------------------------------------\n";

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	len = (int)strlen(data);

	cout << "---------------------------------------\n" << flush;

	pout.write(data,len);
	pout << flush;

	DOIT(0,0);
	DOIT(buf,10);
	DOIT(buf,len-1);
	DOIT(buf,len);
	DOIT(buf,len+1);
	DOIT(buf,(int)sizeof(buf));

	SLEEP(1);
	cout << "About to close() with childisdead() = " << pout.childisdead();
	cout << " and errno = " << errno << "\n";
	pout.close();
	SLEEP(1);
	cout << "Closed.  childisdead() = " << pout.childisdead() << "\n";

	SLEEP(1);  // give cat time to catch up
	cout << "---------------------------------------\n";
	}


