// @(#)tp2.C	1.3
#include <stream.h> 
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

  // Use SLEEP to hide errno which is generated by exiting from sleep on the Suns
#define SLEEP(_x) { int storeerrno; storeerrno = errno; sleep(_x); errno = storeerrno; }

#define DOIT(_b,_l) \
	{ \
	SLEEP(1); \
	pout.setbuf(_b,_l); \
	if (!pout) cerr << "setbuf() failed, line " << __LINE__ << "\n"; \
	pout.write(data,len); \
	pout << flush; \
	if (!pout) cerr << "write() or flush failed, line " << __LINE__ << " errno = " << errno << "\n"; \
	}

void main()
	{
	static char data[] = "123456789012345678901234567890123456789\n";
	char buf[80];
	int len;
	opstream 	pout("line");

	cout << "This test is very similar to tp1.\n";
	cout << "It will try to write a single block of data\n";
	cout << "to the input of a \"line\" process several times\n";
	cout << "using a different buffer size each time.  Since\n";
	cout << "\"line\" only accepts one line of input, it\n";
	cout << "should fail after the first line.  It pauses after\n";
	cout << "writing each line to give \"line\" time to die - otherwise\n";
	cout << "it might get away with filling the pipe's internal\n";
	cout << "buffer before \"line\" dies.  You should\n";
	cout << "see the following output on your screen:\n";
	cout << "---------------------------------------\n";
	cout << "123456789012345678901234567890123456789\n";
	cout << "write() or flush failed, line 60 errno = 0\n";
	cout << "write() or flush failed, line 61 errno = 0\n";
	cout << "write() or flush failed, line 62 errno = 0\n";
	cout << "write() or flush failed, line 63 errno = 0\n";
	cout << "write() or flush failed, line 64 errno = 0\n";
	cout << "write() or flush failed, line 65 errno = 0\n";
	cout << "About to close() with childisdead() = 1 and errno = 0\n";
	cout << "---------------------------------------\n" << flush;

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	len = (int)strlen(data);

	cout << "---------------------------------------\n" << flush;

	pout.write(data,len);
	pout << flush;

	DOIT(0,0);
	DOIT(buf,10);
	DOIT(buf,len-1);
	DOIT(buf,len);
	DOIT(buf,len+1);
	DOIT(buf,(int)sizeof(buf));

	cout << "About to close() with childisdead() = " << pout.childisdead();
	cout << " and errno = " << errno << "\n";

	SLEEP(1);  // give cat time to catch up
	cout << "---------------------------------------\n";
	}


