// @(#)tp3.C	1.4
#include <stream.h> 
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

#define MAXBUF 4
#define CHK if (!pout) cerr << "Pipe has an error after output at line " << __LINE__ << "\n";

  // Use SLEEP to hide errno which is generated by exiting from sleep on the Suns
#define SLEEP(_x) { int storeerrno; storeerrno = errno; sleep(_x); errno = storeerrno; }

void main()
	{
	static char data[] = "A test of many write()s.\n";
	char buf[MAXBUF];
	int cnt;
	opstream 	pout("cat");

	cout << "This tests various manipulators outputting to \n";
	cout << "cat with different buffer sizes.  You should\n";
	cout << "see the following output on your screen:\n";
	cout << "---------------------------------------\n";
	cout << "*** bufsize = 0\n";
	cout << "A test of many write()s.\n";
	cout << "Numerical output: dec 250 oct 372 hex fa float 250\n";
	cout << "*** bufsize = 1\n";
	cout << "A test of many write()s.\n";
	cout << "Numerical output: dec 250 oct 372 hex fa float 250\n";
	cout << "*** bufsize = 2\n";
	cout << "A test of many write()s.\n";
	cout << "Numerical output: dec 250 oct 372 hex fa float 250\n";
	cout << "*** bufsize = 3\n";
	cout << "A test of many write()s.\n";
	cout << "Numerical output: dec 250 oct 372 hex fa float 250\n";
	cout << "*** bufsize = 4\n";
	cout << "A test of many write()s.\n";
	cout << "Numerical output: dec 250 oct 372 hex fa float 250\n";
	cout << "***\n";
	cout << "About to close() with childisdead() = 0 and errno = 0\n";
	cout << "---------------------------------------\n";
	
	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	cout << "---------------------------------------\n" << flush;


	for (cnt = 0; cnt <= MAXBUF; ++cnt)
		{
		pout.setbuf(buf,cnt);
		if (!pout)
			cerr << "Setbuf failed\n";

		pout << "*** bufsize = " << dec << cnt << "\n";
		pout.write(data,3);
		CHK;
		pout.write(data+3,(int)strlen(data)-3);
		CHK;
		pout << "Numerical output: dec " << dec << 250;
		CHK;
		pout << " oct " << oct << 250 ;
		CHK;
		pout << " hex " << hex << 250 ;
		CHK;
		pout << " float " << 250.0 << "\n";
		CHK;
		pout << flush;
		}

	SLEEP(1);  // give cat time to catch up
	cout << "***\n";
	cout << "About to close() with childisdead() = " << pout.childisdead();
	cout << " and errno = " << errno << "\n";

	cout << "---------------------------------------\n";
	}


