// @(#)tp4.C	1.3
#include <stream.h> 
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

  // Use SLEEP to hide errno which is generated by exiting from sleep on the Suns
#define SLEEP(_x) { int storeerrno; storeerrno = errno; sleep(_x); errno = storeerrno; }

#define DOIT(_b,_l) \
	{ \
	pin.clear(); \
	pin.open("cat <tmpfile"); \
	if (!pin) \
		cerr << "Failed to open 'cat <tmpfile', line " << __LINE__ << "\n"; \
	pin.setbuf(_b,_l); \
	if (pin.fail()) \
		{ \
		cerr << "setbuf() failed, line " << __LINE__ << "\n"; \
		pin.clear(); \
		} \
	pin.read(datain,len); \
	if (!pin) \
		cerr << "read() failed, line " << __LINE__ << "\n"; \
	else \
		{ \
		cout << "Got: "; \
		cout.write(datain,len); \
		cout << flush; \
		} \
	pin.close(); \
	SLEEP(1); \
	}

void main()
	{
	static char data[] = "123456789012345678901234567890123456789\n";
	char datain[sizeof(data)];
	char buf[80];
	int len, cnt;
	ofstream fout("tmpfile");

	cout << "This test will create a file called \"tmpfile\" (be warned\n";
	cout << "that it will destroy a file of this name if it already\n";
	cout << "exists).  It will put some data into the file, and then\n";
	cout << "do read()s from \"cat <tmpfile\" with different sized buffers\n";
	cout << "(it re-open()s the pipe each time the buffer size is changed).\n";
	cout << "It pauses for 1 second after each read() to give you enough\n";
	cout << "time to force it to fail by modifying \"tmpfile\" while it is\n";
	cout << "running.  If it does not fail, it should output:\n";
	cout << "---------------------------------------\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "About to exit with errno = 0\n";
	cout << "---------------------------------------\n";

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	len = (int)strlen(data);
	
	cout << "---------------------------------------\n" << flush;

	for (cnt = 7; cnt > 0; --cnt)
		fout.write(data,len);

	if (!fout)
		{
		cerr << "Write to 'tmpfile' failed\n";
		return;
		}
	fout.close();

	ipstream pin;

	DOIT(0,0);
	DOIT(buf,11);
	DOIT(buf,len-1);
	DOIT(buf,len);
	DOIT(buf,len+1);
	DOIT(buf,(int)sizeof(buf));

	cout << "About to exit with errno = " << errno << "\n";

	cout << "---------------------------------------\n";
	unlink("tmpfile");
	}


