// @(#)tp5.C	1.3
#include <stream.h> 
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

#define DOIT \
	{ \
	pin.read(datain,len); \
	if (!pin) \
		cerr << "read() failed, line " << __LINE__ << "\n"; \
	else \
		{ \
		cout << "Got: "; \
		cout.write(datain,len); \
		cout << flush; \
		} \
	}

void main()
	{
	static char data[] = "123456789012345678901234567890123456789\n";
	char datain[sizeof(data)];
	int len, cnt;
	ofstream fout("tmpfile");

	cout << "This test will create a file called \"tmpfile\" (be warned\n";
	cout << "that it will destroy a file of this name if it already\n";
	cout << "exists).  It will put some data into the file, and then\n";
	cout << "do unbuffered read()s from \"line <tmpfile\".  Since \"line\"\n";
	cout << "will only give it one line of input and it will try\n";
	cout << "to read more, it should fail.  The following should \n";
	cout << "appear on your screen:\n";
	cout << "---------------------------------------\n";
	cout << "Got: 123456789012345678901234567890123456789\n";
	cout << "read() failed, line 65\n";
	cout << "read() failed, line 66\n";
	cout << "About to close() with childisdead() = 1 and errno = 0\n";
	cout << "---------------------------------------\n";
	
	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	len = (int)strlen(data);
	
	cout << "---------------------------------------\n" << flush;

	for (cnt = 7; cnt > 0; --cnt)
		fout.write(data,len);

	if (!fout)
		{
		cerr << "Write to 'tmpfile' failed\n";
		return;
		}
	fout.close();

	ipstream pin("line <tmpfile");
	if (!pin)
		cerr << "failed to open pipe\n";

	DOIT;
	DOIT;
	DOIT;

	cout << "About to close() with childisdead() = " << pin.childisdead();
	cout << " and errno = " << errno << "\n";
	cout << "---------------------------------------\n";
	unlink("tmpfile");
	}


