// @(#)tp6.C	1.3
#include <stream.h> 
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

  // Use SLEEP to hide errno which is generated by exiting from sleep on the Suns
#define SLEEP(_x) { int storeerrno; storeerrno = errno; sleep(_x); errno = storeerrno; }

#define MAXBUF 4
#define CHK if (!pin) cerr << "Pipe has an error after input at line " << __LINE__ << "\n"
#define DOIT(_t) \
	{ \
	val = 0; \
	pin >> _t >> val; \
	CHK; \
	cout << " " << val; \
	}


void main()
	{
	static char data[] = "A test of many read()s.\n";
	char got[sizeof(data)];
	char buf[MAXBUF];
	int cnt, val;
	float fval;
	ofstream fout("tmpfile");
	ipstream 	pin;

	cout << "This test will create a file called \"tmpfile\" (be warned\n";
	cout << "that it will destroy a file of this name if it already\n";
	cout << "exists).  It then gets its input from \"cat <tmpfile\".  It\n";
	cout << "reads numbers etc. (using manipulators to select different\n";
	cout << "bases) for several different buffer sizes (the pipe is\n";
	cout << "re-opened for each buffer size).  You should see:\n";
	cout << "---------------------------------------\n";
	cout << "*** bufsize = 0\n";
	cout << "A test of many read()s.\n";
	cout << "Values:  250 250 250 250.01\n";
	cout << "*** bufsize = 1\n";
	cout << "A test of many read()s.\n";
	cout << "Values:  250 250 250 250.01\n";
	cout << "*** bufsize = 2\n";
	cout << "A test of many read()s.\n";
	cout << "Values:  250 250 250 250.01\n";
	cout << "*** bufsize = 3\n";
	cout << "A test of many read()s.\n";
	cout << "Values:  250 250 250 250.01\n";
	cout << "*** bufsize = 4\n";
	cout << "A test of many read()s.\n";
	cout << "Values:  250 250 250 250.01\n";
	cout << "***\n";
	cout << "About to exit with childisdead() = 1 and errno = 0\n";
	cout << "---------------------------------------\n";

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	fout << data;
	fout << dec << 250 << " " << oct << 250  << " " << hex << 250  << " " << 250.01 << "\n" << flush;
	fout.close();

	cout << "---------------------------------------\n" << flush;


	for (cnt = 0; cnt <= MAXBUF; ++cnt)
		{
		pin.setbuf(buf,cnt);
		if (!pin)
			cerr << "Setbuf failed\n";

		pin.open("cat <tmpfile");
		if (!pin)
			cerr << "Open of pipe failed\n";

		cout << "*** bufsize = " << dec << cnt << "\n";

		pin.read(got,3);
		CHK;
		cout.write(got,3);

		pin.read(got,(int)strlen(data)-3);
		CHK;
		cout.write(got,(int)strlen(data)-3);

		cout << "Values: ";

		DOIT(dec);
		DOIT(oct);
		DOIT(hex);

		pin >> fval;
		CHK;
		cout << " " << fval << "\n" << flush;

		pin.close();
		pin.clear();
		}

	cout << "***\n";
	cout << "About to exit with childisdead() = " << pin.childisdead();
	cout << " and errno = " << errno << "\n";

	unlink("tmpfile");
	SLEEP(1);  // give cat time to catch up
	cout << "---------------------------------------\n";
	}


