// @(#)tp7.C	1.3
#include <stream.h>
#include <errno.h>
#include <stdlib.h>
#include <osfcn.h>
#include "pstream.h"

void main()
	{
	int cnt;
	int val;
	pstream io("tp_mult2",input|output);

	cout << "This program tests read/write piping.  It pipes to a program\n";
	cout << "called \"tp_mult2\" which reads numbers from stdin, multiplies\n";
	cout << "them by 2, and outputs the result to stdout.  tp7 starts\n";
	cout << "with val=7, outputs this to tp_mult2, and uses the result\n";
	cout << "which it reads as a new value for val.  It continues this process\n";
	cout << "several times.  The output should be:\n";
	cout << "---------------------------------------\n";
	cout << "val = 7\n";
	cout << "val = 14\n";
	cout << "val = 28\n";
	cout << "val = 56\n";
	cout << "val = 112\n";
	cout << "About to close with childisdead() = 0 errno = 0\n";
	cout << "---------------------------------------\n";

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	if (!io)
		cerr << "Failed to open pipe\n";

	val = 7;

	cout << "---------------------------------------\n";
	for (cnt = 5; cnt > 0; --cnt)
		{
		cout << "val = " << val << "\n" << flush;
		io << val << "\n";
		if (!io)
			cerr << "IO is failing after write\n";
		io >> val;
		io.get();  // fetch the carriage return that is in the get buffer 
		if (!io)
			cerr << "IO is failing after read\n";
		}

	cerr << "About to close with childisdead() = " << io.childisdead() << " errno = " << errno << "\n";
	cout << "---------------------------------------\n";
	}

