// @(#)tp8.C	1.3
#include <stream.h> 
#include <errno.h>
#include <sys/time.h>
#include <osfcn.h>
#include "pstream.h"

void main()
	{
	static char data[] = "12\n3456789012345678901234567890123456789\n";
	int cnt, ch, fail;
	pstream io("tp_cat",input|output);

	cout << "This program tests a read/write pipe by\n";
	cout << "outputting a bunch of characters one by one to\n";
	cout << "\"tp_cat\" (a version of cat which flushes after each\n";
	cout << "character), reading them back in, and comparing them\n";
	cout << "to what it put out.  You should see:\n";
	cout << "---------------------------------------\n";
	cout << "OK\n";
	cout << "About to close() with childisdead() = 0 and errno = 0\n";
	cout << "---------------------------------------\n";

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	cout << "---------------------------------------\n" << flush;

	fail = 0;
	for (cnt = 0; cnt < sizeof(data); ++cnt)
		{
		io.put(data[cnt]);
		ch = io.get();
		if (ch != data[cnt])
			{
			cerr << "Mismatch at byte " << cnt << "\n";
			fail = 1;
			}
		}
	if (!fail)
		cout << "OK\n" << flush;

	cout << "About to close() with childisdead() = " << io.childisdead();
	cout << " and errno = " << errno << "\n";

	cout << "---------------------------------------\n" << flush;
	}


