// @(#)tp9.C	1.3
#include <osfcn.h>
#include <signal.h>
#include <errno.h>
#include "pstream.h"

  // Use SLEEP to hide errno which is generated by exiting from sleep on the Suns
#define SLEEP(_x) { int storeerrno; storeerrno = errno; sleep(_x); errno = storeerrno; }

#define DEFAULTBUFSIZE 100

void main()
	{
	int ch;

	cout << "This program tests multiple pipes.  It gets characters\n";
	cout << "from 'ls -l' and it outputs them to 'pr -l15' to create\n";
	cout << "file listing with headers etc.  It reads the result from\n";
	cout << "'pr -l15' and outputs it to 'less'.  'less' is run in\n";
	cout << "noshell mode so that it can be killed (since it does\n";
	cout << "not exit when its input is closed).  When you execute\n";
	cout << "this program, 'less' should be invoked with the following\n";
	cout << "message at the top:\n";
	cout << "\n";
	cout << "THIS 'LESS' WILL SELF DESTRUCT IN 5 SECONDS\n";
	cout << "\n";
	cout << "You should then see a double spaced file listing which\n";
	cout << "you can page through for 5 seconds.  Then, the 'less' should\n";
	cout << "die, and you should see:\n";
	cout << "\n";
	cout << "'pr' childisdead() = 1\n";
	cout << "'less' childisdead() = 1\n";
	cout << "errno = 0\n";
	cout << "-------------------------------\n";

	cerr << "Press return to start: " << flush;
	cin.get();  // get a character

	opstream pout("less",noshell);
	ipstream pin("ls -l");
	pstream pr("pr -l15",input|output);
	char *buf;
	int numbytes;

	if (!pout || !pin || !pr)
		cerr << "Unable to open pipe\n";

	pout << "\nTHIS 'LESS' WILL SELF DESTRUCT IN 5 SECONDS\n\n" << flush;
	while (pin)
		{
		ch = pin.get();  // get char from 'ls -l'
		if (ch != EOF)
			pr.put(ch);  // put the char into 'pr -d'
		pr << flush;
			// Number of bytes available are those in the get buffer plus those in the pipeline
		numbytes = pr.rdbuf()->in_avail() + pr.bytesinpipe(input); // Want all the bytes available at the moment
		if (numbytes > 0)  // We do this because if we do a read it will try to get chars even if we ask for 0
			{
			buf = new char[numbytes];
			pr.read(buf,numbytes);
			pout.write(buf,numbytes); // write the result to 'less'
			pout << flush;
			delete[] buf;
			}
		}
	pr.close(output);  // Done outputting to 'pr'
		// 'pr' may take a while to finish, so just keep fetching chars till there are no more
	buf = new char[DEFAULTBUFSIZE];
	while (pr)
		{
		pr.read(buf,DEFAULTBUFSIZE);
		pout.write(buf,pr.gcount());
		}

	pout << "\nEND OF FILE LISTING\n" << flush;
	pin.close();
	pr.close();
	pout.close();
	SLEEP(5);

	int prisdead;
	prisdead = pr.childisdead();  // it has been closed - should have died

	kill(pout.childpid(),SIGKILL);
	SLEEP(1);
	cout << "\n'pr' childisdead() = " << prisdead << "\n";
	cout << "'less' childisdead() = " << pout.childisdead() << "\n";
	cout << "errno = " << errno << "\n" << flush;
	}
